#!/bin/python3

import sys
from math import gcd

input_file = sys.argv[1]
diffout = sys.argv[3]

def check(n, x):
    a = x[0]
    b = x[1]
    c = x[2]
    return a > n and b > n and c > n and gcd(a, b) == 1 and a*a+b*b == c*c and a < 2*n*n and b < 2*n*n and c < 2*n*n

with open(input_file, "r") as f, open(diffout + "/judgemessage.txt", "w") as f2:
    n, k = tuple(map(int, f.readlines()))

    try: 
        lines=  []
        for _ in range(k):
            line = input()
            lines.append(line)
    except EOFError:
        f2.write("Not enough lines were provided.\n")
        sys.exit(43)
    
    for line in lines:
        try:
            x = tuple(map(int, line.split()))
        except:
            f2.write("Output should be three intergers a, b, c where c^2 = a^2 + b^2\n")
            sys.exit(43)
        if not check(n, x):
            f2.write("Wrong answer.\n")
            sys.exit(43)
    
    try:
        input()
        f2.write("Too many lines were provided.\n")
        sys.exit(43)
    except EOFError:
        pass
    sys.exit(42)